---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：32-routes.json（Bundle Analyzer）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **バンドルアナライザーUIの詳細仕様**：UIアセット側の詳細は未調査

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/analyze/index.ts` 行42-122（analyze関数）
- E-02: `packages/next/src/build/analyze/index.ts` 行128-208（collectRoutesForAnalyze関数）
- E-03: `packages/next/src/build/analyze/index.ts` 行33-40（AnalyzeOptions型）
- E-04: `packages/next/src/build/analyze/index.ts` 行88-91（routes.json書き込み処理）
- E-05: `packages/next/src/build/analyze/index.ts` 行210-254（startServer関数）
- E-06: `packages/next/src/build/analyze/index.ts` 行205-207（ルート連結処理）
- E-07: `packages/next/src/build/analyze/index.ts` 行84-87（バンドルアナライザーUIコピー）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | next experimental-analyzeコマンドで生成される | E-01 | ○ |
| C-02 | 出力先は.next/diagnostics/analyze/data/routes.json | E-04 | ○ |
| C-03 | Turbopackを使用してビルドが行われる | E-01（行74-75） | ○ |
| C-04 | 出力は文字列配列（ルートパスの配列） | E-06 | ○ |
| C-05 | dynamicRoutes + staticRoutesが連結される | E-06 | ○ |
| C-06 | pages/appディレクトリが見つからない場合エラー | E-02（行144） | ○ |
| C-07 | --outputオプションでファイル出力が可能 | E-01（行94-96, 107-109） | ○ |
| C-08 | HTTPサーバーのデフォルトポートは4000 | E-03, E-05（行210） | ○ |
| C-09 | localhostにバインドされる | E-05（行226） | ○ |
| C-10 | App RouterのパスはnormalizeAppPathで正規化 | E-02（行179） | ○ |
| C-11 | appDirOnlyオプションでApp Routerのみ収集可能 | E-03, E-02 | ○ |
| C-12 | テレメトリが記録される | E-01（行99-105） | ○ |
| C-13 | バンドルアナライザーUIは別ディレクトリからコピー | E-07 | ○ |
| C-14 | バンドルアナライザーUIの詳細な構造 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: バンドルアナライザーUIの内部構造・表示形式についてはUIアセット側を調査していない
  - 候補：`packages/next/src/bundle-analyzer/` ディレクトリ内のファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - analyze関数の処理フローは明確にソースコードで確認
- 0: 低リスク - routes.jsonの出力形式は確実
- 1: 中リスク - 実験的機能のためAPIが将来変更される可能性

## 6) レビュアーチェックリスト（最小）
- [ ] routes.jsonの出力パスが正しいことを確認
- [ ] collectRoutesForAnalyzeのルート収集ロジックが網羅的か確認
- [ ] HTTPサーバーのセキュリティ（localhost限定バインド）が正しいか確認
